#pragma once

//for internal use

class IGetNextFrame
{
    protected:
        int nFrameCount;
    public:
        IGetNextFrame(int fc) : nFrameCount(fc) { }
        virtual int GetNextFrame(int nCurrentFrame) = 0;
};

class GetNextFrameDefault : public IGetNextFrame
{
    public:
        GetNextFrameDefault(int fc) : IGetNextFrame(fc) { }
        
        int GetNextFrame(int nCurrentFrame)
        {
            ++nCurrentFrame;
            if(nCurrentFrame == nFrameCount) return -1;
            else return nCurrentFrame;
        }
};

class GetNextFrameLua : public IGetNextFrame
{
        lua_State* ls;
    public:
        class ScriptError { };
        
        GetNextFrameLua(const char* script, int fc) : IGetNextFrame(fc)
        {
            ls = luaL_newstate();
            luaL_openlibs(ls);
            if(luaL_dofile(ls, script) != 0) //when error
            {
                lua_close(ls);
                throw ScriptError();
            }
            
            //save frame count number into global var
            lua_pushinteger(ls, nFrameCount);
            lua_setglobal(ls, "FrameCount");
        }
        
        ~GetNextFrameLua()
        {
            lua_close(ls);
        }
        
        int GetNextFrame(int nCurrentFrame)
        {
            lua_getglobal(ls, "GetNextFrame");
            lua_pushinteger(ls, nCurrentFrame);
            if (lua_pcall(ls, 1, 1, 0) == 0)
            {
                return lua_tointeger(ls, lua_gettop(ls));
            }
            else
            {
                throw ScriptError();
            }
        }
};