#pragma once

#include "avisynth.h"

#include <boost/interprocess/sync/interprocess_mutex.hpp>
#include <boost/interprocess/sync/interprocess_condition.hpp>

#pragma pack(push, 16)
struct VideoFrameExchangeHeader
{
    //global info
    VideoInfo vi;
    int nFrameSize;
    
    //request
    enum { ReqGetFrame = 0, ReqGetParity, ReqSetCacheHints };
    int nRequest;
    
    int GetParityParam1;
    
    int SetCacheHintsParam1;
    int SetCacheHintsParam2;
    
    int GetFrameParam1;
    
    //response
    int GetParityResponse;
    
    //ready?
    boost::interprocess::interprocess_mutex eventMutex;
    boost::interprocess::interprocess_condition requestReady;
    boost::interprocess::interprocess_condition responseReady;
};
#pragma pack(pop)
