#define BOOST_ALL_NO_LIB
#include <windows.h>
#include "avisynth.h"

#include <boost/interprocess/sync/interprocess_recursive_mutex.hpp>
#include <boost/interprocess/managed_windows_shared_memory.hpp>
#include <boost/interprocess/sync/interprocess_condition.hpp>
#include <boost/interprocess/sync/scoped_lock.hpp>

#include <boost/bind.hpp>
#include <boost/shared_ptr.hpp>

#include <algorithm>
#include <fstream>
#include <string>

using namespace boost::interprocess;
using std::string;


typedef managed_windows_shared_memory SMAllocT;

struct BufferedFrame
{
    int nFrame; //֡
    int nLifeTimeLeft; //ʼֵڻ֡ÿһξͼһС0ʱ
    int nSize; //֡ݴС
    offset_ptr<char> rData; //֡

    BufferedFrame(const BufferedFrame& bf)
    {
        nFrame = bf.nFrame;
        nLifeTimeLeft = bf.nLifeTimeLeft;
        nSize = bf.nSize;
        rData = bf.rData;
    }
    
    BufferedFrame()
    {
        nSize = 0;
    }
    
    int GetSize()
    {
        return nSize;
    }
    
    int GetFrameNumber()
    {
        return nFrame;
    }
    
    void ClearFrame(SMAllocT& alloc)
    {
        if(nSize != 0)
            alloc.deallocate(rData.get());
        nSize = 0;
    }
    
    void GetFrame(void* buf, int n)
    {
        char* src = (char*) rData.get();
        std::copy(src, src+n, (char*)buf);
    }
    
    void SaveFrame(SMAllocT& alloc, int nf, int size, const void* buf, int lifetime)
    {
        ClearFrame(alloc);
        nFrame = nf;
        nSize = size;
        nLifeTimeLeft = lifetime;
        rData = (char*) alloc.allocate(nSize);
        char* dst = (char*) rData.get();
        char* src = (char*) buf;
        std::copy(src, src+nSize, dst);
    }
    
    bool ReduceLifeTime()
    {
        if(--nLifeTimeLeft <= 0)
            return true;
        else
            return false;
    }
};

class SoraProcessInt
{
    private:
        //֡
        int nFrameCount;

        //壬û֡ݴԺƶ
        int nBufferCount;
        interprocess_mutex frameBufferMutex;
        
        //ʱ֪ͨ
        interprocess_condition frameBufferChangedEvent;
        
        //һ֡ʲô
        int nNextFrameToRead;
        interprocess_mutex nextFrameToReadMutex;
        
        //֪ͨ߳
        interprocess_mutex startEventMutex;
        interprocess_condition startEvent;
        
        PClip child;
    public:
        VideoInfo vi;
        
        SoraProcessInt(PClip _child, int bc)
            : child(_child)
            , nBufferCount(bc)
        {
            vi = child->GetVideoInfo();
            nFrameCount = vi.num_frames;
            nNextFrameToRead = -1;
        }
        
        ~SoraProcessInt()
        {
        }
        
        PVideoFrame GetFrame(SMAllocT& alloc, BufferedFrame* frameBuffer, int n, IScriptEnvironment* env)
        {
            PVideoFrame frame = env->NewVideoFrame(vi);

            if( SearchBuffer(alloc, frameBuffer, n, frame) ) //ڻҵҪ֡
            {
                ;
            }
            else //ûҵ趨һ֡Ժȴ
            {
                {
                    scoped_lock<interprocess_mutex> lg(nextFrameToReadMutex);
                    nNextFrameToRead = n;
                }
                frameBufferChangedEvent.notify_all();
                WaitForFrame(alloc, frameBuffer, n, frame);
            }
            
            return frame;
        }
        
        int CountBuffer(BufferedFrame* buf)
        {
            int s = 0;
            for(int i = 0; i < nBufferCount; ++i)
            {
                if(buf[i].nSize != 0)
                    s += 1;
            }
            return s;
        }
        
        void AddBuffer(BufferedFrame* buf, BufferedFrame& b)
        {
            int i;
            for(i = 0; i < nBufferCount; ++i)
                if(buf[i].nSize == 0) break;
            buf[i] = b;
        }
        
        bool SearchBuffer(SMAllocT& alloc, BufferedFrame* buf, int nFrame, PVideoFrame& frame, bool lock = true) //һ
        {
            if(lock) frameBufferMutex.lock();
            
            for(int i = 0; i < nBufferCount; ++i)
            {
                if(buf[i].GetFrameNumber() == nFrame)
                {
                    int nSize = frame->GetFrameBuffer()->GetDataSize() - frame->GetOffset();
                    nSize = nSize > buf[i].GetSize() ? buf[i].GetSize() : nSize;
                    buf[i].GetFrame(frame->GetWritePtr(), nSize);
                    buf[i].ClearFrame(alloc);
                    frameBufferChangedEvent.notify_all();
                    
                    frameBufferMutex.unlock();
                    return true;
                }
            }
            
            if(lock) frameBufferMutex.unlock();
            return false;
        }
        
        void BufferFrame(int nFrame, PVideoFrame frame, SMAllocT& alloc, BufferedFrame* frameBuffer, bool lock = true)
        {
            scoped_lock<interprocess_mutex> lg(frameBufferMutex);
            
            while( CountBuffer(frameBuffer) == nBufferCount ) //˻ȴ
            {
                frameBufferChangedEvent.wait(lg);
            }
            
            ReduceBufferedFrameLifeTime(alloc, frameBuffer);
            
            BufferedFrame bf;
            int nSize = frame->GetFrameBuffer()->GetDataSize() - frame->GetOffset();
            bf.SaveFrame(alloc, nFrame, nSize, frame->GetReadPtr(), nBufferCount);
            
            AddBuffer(frameBuffer, bf);
            
            frameBufferChangedEvent.notify_all();
        }
        
        void ReduceBufferedFrameLifeTime(SMAllocT& alloc, BufferedFrame* buf)
        {
            for(int i = 0; i < nBufferCount; ++i)
            {
                if(buf[i].nSize != 0)
                {
                    if(buf[i].ReduceLifeTime())
                    {
                        buf[i].ClearFrame(alloc);
                    }
                }
            }

            frameBufferChangedEvent.notify_all();
        }
        
        void WaitForFrame(SMAllocT& alloc, BufferedFrame* frameBuffer, int nFrame, PVideoFrame& frame)
        {
            scoped_lock<interprocess_mutex> lg(frameBufferMutex);
            
            while(SearchBuffer(alloc, frameBuffer, nFrame, frame, false) == false)
            {
                while( CountBuffer(frameBuffer) == nBufferCount)
                    ReduceBufferedFrameLifeTime(alloc, frameBuffer);
                
                startEvent.notify_all();
                frameBufferChangedEvent.wait(lg);
            }
        }
        
        void StartServer(SMAllocT& alloc, BufferedFrame* frameBuffer, IScriptEnvironment* env)
        {
            for(;;)
            {
                int nFrameToRead;
                {
                    scoped_lock<interprocess_mutex> lg(nextFrameToReadMutex);
                    nFrameToRead = nNextFrameToRead;
                    nNextFrameToRead = GetNextFrameToRead(nNextFrameToRead);
                }
                {
                    scoped_lock<interprocess_mutex> lg(startEventMutex);
                    while(nFrameToRead == -1)
                    {
                        startEvent.wait(lg);
                        {
                            scoped_lock<interprocess_mutex> lg(nextFrameToReadMutex);
                            nFrameToRead = nNextFrameToRead;
                        }
                    }
                }
                PVideoFrame vf = child->GetFrame(nFrameToRead, env);
                
                BufferFrame(nFrameToRead, vf, alloc, frameBuffer);
            }
        }
        
        int GetNextFrameToRead(int nCurrentFrame)
        {
            ++nCurrentFrame;
            if(nCurrentFrame == nFrameCount) return -1;
            else return nCurrentFrame;
        }
};

class SoraProcess : public IClip
{
        managed_windows_shared_memory alloc;
        BufferedFrame* buffer;
        SoraProcessInt* sorap;
    public:
        SoraProcess() : alloc(open_or_create, "MySharedMemory", 104857600)
        {
            buffer = alloc.find<BufferedFrame>("mybuffer").first;
            sorap = alloc.find<SoraProcessInt>("mysorap").first;
        }
        
        PVideoFrame __stdcall GetFrame(int n, IScriptEnvironment* env)
        {
            return sorap->GetFrame(alloc, buffer, n, env);
        }
        
        bool __stdcall GetParity(int n)
        {
            return false;
        }
        void __stdcall GetAudio(void* buf, __int64 start, __int64 count, IScriptEnvironment* env)
        {
            return;
        }
        void __stdcall SetCacheHints(int cachehints,int frame_range)
        {
        }
        const VideoInfo& __stdcall GetVideoInfo()
        {
            return sorap->vi;
        }
};

AVSValue __cdecl Create_SoraProcess(AVSValue args, void* user_data, IScriptEnvironment* env)
{
    return AVSValue(new SoraProcess());
}

extern "C" __declspec(dllexport) const char* __stdcall AvisynthPluginInit2(IScriptEnvironment* env)
{
    env->AddFunction("SoraProcess", "[Buffer]i[Name]s", Create_SoraProcess, 0);
    return 0;
}

IScriptEnvironment* (__stdcall *CSE)(int);

int main()
{
    CSE = (IScriptEnvironment* (__stdcall*) (int)) GetProcAddress(LoadLibrary("avisynth.dll"), "CreateScriptEnvironment");
    IScriptEnvironment* env = (*CSE)(AVISYNTH_INTERFACE_VERSION);

    std::fstream fs("1.avs", std::ios::in);
    string buf;
    for(;;)
    {
        string l;
        getline(fs, l);
        if(fs.eof()) break;
        buf += l + "\r\n";
    }
    fs.close();
    
    //run avs
    PClip p = env->Invoke("eval", buf.c_str()).AsClip();
    
    managed_windows_shared_memory alloc(open_or_create, "MySharedMemory", 104857600);
    BufferedFrame* buffer;
    SoraProcessInt* sorap;
 
    buffer = alloc.construct<BufferedFrame>("mybuffer")[10]();
    sorap = alloc.construct<SoraProcessInt>("mysorap")(p, 10);
    
    sorap->StartServer(alloc, buffer, env);
}
