#define BOOST_ALL_NO_LIB

#include "windows.h"
#include "avisynth.h"
#include "smframestruct.h"

#include <string>
#include <iostream>
#include <fstream>

#include <boost/interprocess/windows_shared_memory.hpp>
#include <boost/interprocess/mapped_region.hpp>
#include <boost/interprocess/sync/scoped_lock.hpp>
#include <boost/scoped_ptr.hpp>

#include <exception>

using namespace boost::interprocess;
using namespace std;

IScriptEnvironment* (__stdcall *CSE)(int);

int main(int argc, char* argv[])
{
    CSE = (IScriptEnvironment* (__stdcall*) (int)) GetProcAddress(LoadLibrary("avisynth.dll"), "CreateScriptEnvironment");
    boost::scoped_ptr<IScriptEnvironment> env( (*CSE)(AVISYNTH_INTERFACE_VERSION) );
    
    if(argc != 3)
    {
        puts("how to use:");
        puts("sorasmserver.exe shared_memory_name avs_script_file");
        return 1;
    }
    else
    {
        //read the whole avs
        fstream fs(argv[2], std::ios::in);
        if(!fs)
        {
            puts("fail to open avs script file");
        }
        else
        {
			fs.seekg(0, std::ios::end);
			int flen = fs.tellg();
			fs.seekg(0, std::ios::beg);
            string buf(flen, ' ');
			fs.read(&buf[0], flen);
            fs.close();
            
            try
            {
                //run avs
                PClip p = env->Invoke("eval", buf.c_str()).AsClip();
                int videoLen;
                { //get length
                    PVideoFrame vf = p->GetFrame(0, env.get());
                    videoLen = vf->GetFrameBuffer()->GetDataSize();
                }
                //create shared memory
                int shmSize = sizeof(VideoFrameExchangeHeader) + videoLen;
                windows_shared_memory shm(create_only, argv[1], read_write, shmSize);
                
                //get pointer
                mapped_region r(shm, read_write);
                VideoFrameExchangeHeader* header = (VideoFrameExchangeHeader*) r.get_address();
                void* data = (char*) r.get_address() + sizeof(VideoFrameExchangeHeader);
                
                //create object
                new(header) VideoFrameExchangeHeader;
                
                //set global info
                header->nFrameSize = videoLen;
                memcpy(&header->vi, &p->GetVideoInfo(), sizeof(VideoInfo));
                
                cout << "Ready to serve frames" << endl;
                //first time wait
                {
                    scoped_lock<interprocess_mutex> lg(header->eventMutex);
                    header->requestReady.wait(lg);
                }
                //start server
                for(;;)
                {
                    //process
                    switch(header->nRequest)
                    {
                        case VideoFrameExchangeHeader::ReqSetCacheHints:
                        {
                            //I don't know why it crashes avisynth...
                            //p->SetCacheHints(header->SetCacheHintsParam1, header->SetCacheHintsParam2);
                            break;
                        }
                        case VideoFrameExchangeHeader::ReqGetParity:
                        {
                            header->GetParityResponse = p->GetParity(header->GetParityParam1);
                            break;
                        }
                        case VideoFrameExchangeHeader::ReqGetFrame:
                        {
                            PVideoFrame vf = p->GetFrame(header->GetFrameParam1, env.get());
                            int nSize = vf->GetFrameBuffer()->GetDataSize() - vf->GetOffset();
                            nSize = nSize > videoLen ? videoLen : nSize;
                            memcpy(data, vf->GetReadPtr(), nSize);
                            break;
                        }
                    }
                    //wait
                    {
                        scoped_lock<interprocess_mutex> lg(header->eventMutex);
                        header->responseReady.notify_one();
                        header->requestReady.wait(lg);
                    }
                }
                
                header->~VideoFrameExchangeHeader();
            }
            catch(AvisynthError e)
            {
                cout << "Avisynth script error: " << e.msg << endl;
            }
        }

    }
}


