#define BOOST_ALL_NO_LIB
#include "windows.h"
#include "avisynth.h"
#include <boost/interprocess/windows_shared_memory.hpp>
#include <boost/interprocess/mapped_region.hpp>
#include <boost/interprocess/sync/named_condition.hpp>
#include <boost/interprocess/sync/scoped_lock.hpp>
#include <cstring>

#include "smframestruct.h"

using namespace boost::interprocess;

class SharedMemorySource : public IClip
{
        VideoInfo vi;
        windows_shared_memory* sm;
        mapped_region* region;
        VideoFrameExchangeHeader* header;
    public:
        SharedMemorySource(IScriptEnvironment* env, const char* smName) : sm(0)
        {
            try
            {
                sm = new windows_shared_memory(open_only, smName, read_write);
                region = new mapped_region(*sm, read_write);
                
                header = (VideoFrameExchangeHeader*) region->get_address();
                std::memcpy(&vi, &header->vi, sizeof(VideoInfo));
            }
            catch(...)
            {
                env->ThrowError("SoraSharedMemorySource: No available server.");
            }
        }

        PVideoFrame __stdcall GetFrame(int n, IScriptEnvironment* env)
        {
            {
                scoped_lock<interprocess_mutex> lg(header->eventMutex);
                header->nRequest = VideoFrameExchangeHeader::ReqGetFrame;
                header->GetFrameParam1 = n;
                header->requestReady.notify_one();
                header->responseReady.wait(lg);
            }
            PVideoFrame frame = env->NewVideoFrame(vi);
            int nSize = frame->GetFrameBuffer()->GetDataSize() - frame->GetOffset();
            nSize = nSize > header->nFrameSize ? header->nFrameSize : nSize;
            memcpy(frame->GetWritePtr(), ((const char*)header + sizeof(*header)), nSize);
            return frame;
        }
        
        bool __stdcall GetParity(int n)
        {
            {
                scoped_lock<interprocess_mutex> lg(header->eventMutex);
                header->nRequest = VideoFrameExchangeHeader::ReqGetParity;
                header->GetParityParam1 = n;
                header->requestReady.notify_one();
                header->responseReady.wait(lg);
            }
            return header->GetParityResponse;
        }
        
        void __stdcall GetAudio(void* buf, __int64 start, __int64 count, IScriptEnvironment* env)
        {
            return;
        }
        
        void __stdcall SetCacheHints(int cachehints,int frame_range)
        {
            {
                scoped_lock<interprocess_mutex> lg(header->eventMutex);
                header->nRequest = VideoFrameExchangeHeader::ReqSetCacheHints;
                header->SetCacheHintsParam1 = cachehints;
                header->SetCacheHintsParam2 = frame_range;
                header->requestReady.notify_one();
                header->responseReady.wait(lg);
            }
        }
        
        const VideoInfo& __stdcall GetVideoInfo()
        {
            return vi;
        }
        
        __stdcall ~SharedMemorySource()
        {
            delete region;
            delete sm;
        }
};

AVSValue __cdecl Create_SoraSMSource(AVSValue args, void* user_data, IScriptEnvironment* env)
{
    if(args[0].IsString())
    {
        return AVSValue(new SharedMemorySource(env, args[0].AsString()));
    }
    else
    {
        env->ThrowError("SoraSMSource:  No available shared memory name!");
        return AVSValue(0);
    }
}

extern "C" __declspec(dllexport) const char* __stdcall AvisynthPluginInit2(IScriptEnvironment* env)
{
    env->AddFunction("SoraSMSource", "s", Create_SoraSMSource, 0);
    return 0;
}
