#define BOOST_ALL_NO_LIB
#include <windows.h>
#include "avisynth.h"

#include <boost/interprocess/sync/interprocess_recursive_mutex.hpp>
#include <boost/interprocess/managed_windows_shared_memory.hpp>
#include <boost/interprocess/sync/interprocess_condition.hpp>
#include <boost/interprocess/sync/scoped_lock.hpp>
#include <boost/scoped_ptr.hpp>
#include <boost/program_options.hpp>

#include <algorithm>
#include <iostream>
#include <fstream>
#include <string>

#include "lua.hpp"

using namespace boost::interprocess;
using std::string;
using std::fstream;
using std::cout;
using std::endl;
namespace po = boost::program_options;

typedef scoped_lock<interprocess_mutex> LockerT;
typedef interprocess_mutex MutexT;
typedef interprocess_condition ConditionT;

#include "getnextframe.h"

#pragma pack(push, 1)
struct SharedBuffer
{
    struct ControlInfo {
        VideoInfo vi; //ƵϢ
        int nFrameCount; //֡
        int nFrameSize; //ÿ֡С
        int nBufferCount; //֡
        int nNextFrameToRead; //һ֡ʲô
        
        //Ϣı¼
        // һ֡ʲôı仯֡ı仯
        MutexT controlInfoMutex;
        ConditionT controlInfoEvent;
    } controlInfo;
    
    struct BufferedFrameHeader
    {
        int nFrame; //֡ţʾڴ
        int nLifeTimeLeft; //ܴλ壬0ʾ
    };
    
    SharedBuffer(VideoInfo& vi, int nFrameCount, int nFrameSize, int nBufferCount)
    {
        this->controlInfo.vi = vi;
        this->controlInfo.nFrameCount = nFrameCount;
        this->controlInfo.nBufferCount = nBufferCount;
        this->controlInfo.nFrameSize = nFrameSize;
        this->controlInfo.nNextFrameToRead = -1;
    }
    
    static int RequiredSize(int nFrameCount, int nFrameSize, int nBufferCount)
    {
        return sizeof(ControlInfo) + (sizeof(BufferedFrameHeader) + nFrameSize) * nBufferCount;
    }

    int GetFrameSize()
    {
        return controlInfo.nFrameSize;
    }
    
    void* GetFramePtr(int n)
    {
        char* startAddr = (char*) this;
        char* dataAddr = startAddr + sizeof(controlInfo);
        char* ptr = dataAddr + n * (sizeof(BufferedFrameHeader) + controlInfo.nFrameSize);
        return ptr;
    }

    void UnlockFrameData(int n)
    {
        LockerT lg(controlInfo.controlInfoMutex);
        
        BufferedFrameHeader* fh = (BufferedFrameHeader*) GetFramePtr(n);
        if(fh->nFrame < 0)
            fh->nFrame = ~fh->nFrame;
            
        controlInfo.controlInfoEvent.notify_all();
    }
    
    void UnlockAndRemoveFrameData(int n)
    {
        LockerT lg(controlInfo.controlInfoMutex);
        
        BufferedFrameHeader* fh = (BufferedFrameHeader*) GetFramePtr(n);
        if(fh->nFrame < 0)
        {
            fh->nFrame = ~fh->nFrame;
            fh->nLifeTimeLeft = 0;
        }
            
        controlInfo.controlInfoEvent.notify_all();
    }
    
    void ReduceFrameLifeTime()
    {
        LockerT lg(controlInfo.controlInfoMutex);
        for(int i = 0; i < controlInfo.nBufferCount; ++i)
        {
            BufferedFrameHeader* ptr = (BufferedFrameHeader*) GetFramePtr(i);
            if(ptr->nLifeTimeLeft > 0 && ptr->nFrame > 0)
            {
                --ptr->nLifeTimeLeft;
            }
        }
        controlInfo.controlInfoEvent.notify_all();
    }
    
    void* FindEmptyFrameForWrite(int nFrame, int& nBuffer /* for unlock */)
    {
        LockerT lg(controlInfo.controlInfoMutex);
        for(;;)
        {
            for(int i = 0; i < controlInfo.nBufferCount; ++i)
            {
                BufferedFrameHeader* ptr = (BufferedFrameHeader*) GetFramePtr(i);
                if(ptr->nLifeTimeLeft <= 0)
                {
                    nBuffer = i;
                    ptr->nFrame = ~nFrame;
                    ptr->nLifeTimeLeft = controlInfo.nBufferCount;
                    return (char*) ptr + sizeof(BufferedFrameHeader);
                }
            }
            controlInfo.controlInfoEvent.wait(lg);
        }
    }
    
    void* FindFrame(int nFrame, int& nBuffer)
    {
        LockerT lg(controlInfo.controlInfoMutex);
        int nMinLifeTime = controlInfo.nBufferCount;
        bool isReading = false;
        for(;;)
        {
            for(int i = 0; i < controlInfo.nBufferCount; ++i)
            {
                BufferedFrameHeader* ptr = (BufferedFrameHeader*) GetFramePtr(i);

                if(ptr->nLifeTimeLeft > 0 && ptr->nFrame == nFrame)
                {
                    nBuffer = i;
                    ptr->nFrame = ~nFrame;
                    return (char*) ptr + sizeof(BufferedFrameHeader);
                }
                if(ptr->nFrame > 0 && ptr->nLifeTimeLeft < nMinLifeTime)
                {
                    nMinLifeTime = ptr->nLifeTimeLeft;
                }
            }
            
            //ûҵһλ
            for(int i = 0; i < controlInfo.nBufferCount; ++i)
            {
                BufferedFrameHeader* ptr = (BufferedFrameHeader*) GetFramePtr(i);
                if(ptr->nFrame > 0)
                {
                    ptr->nLifeTimeLeft -= nMinLifeTime;
                }
            }
            
            controlInfo.nNextFrameToRead = nFrame;
            controlInfo.controlInfoEvent.notify_all();
            controlInfo.controlInfoEvent.wait(lg);
        }
    }
    
    int StepToNextFrameToRead(IGetNextFrame* gnf)
    {
        LockerT lg(controlInfo.controlInfoMutex);
        
        while(controlInfo.nNextFrameToRead == -1)
            controlInfo.controlInfoEvent.wait(lg);
        
        int nFrameToRead = controlInfo.nNextFrameToRead;
        controlInfo.nNextFrameToRead = gnf->GetNextFrame(controlInfo.nNextFrameToRead);
        return nFrameToRead;
    }
};
#pragma pack(pop)

class SharedMemorySource : public IClip
{
        VideoInfo vi;
        windows_shared_memory* sm;
        mapped_region* region;
        SharedBuffer* smbuf;
    public:
        SharedMemorySource(IScriptEnvironment* env, const char* smname) : sm(0), region(0)
        {
            try
            {
                sm = new windows_shared_memory(open_only, smname, read_write);
                region = new mapped_region(*sm, read_write);
                
                smbuf = (SharedBuffer*) region->get_address();
                std::memcpy(&vi, &smbuf->controlInfo.vi, sizeof(VideoInfo));
            }
            catch(...)
            {
                if(region != 0) delete region;
                if(sm != 0) delete sm;
                env->ThrowError("SoraSMSource2:  No available server.");
            }
        }

        PVideoFrame __stdcall GetFrame(int n, IScriptEnvironment* env)
        {
            int nBuffer;
            void* p = smbuf->FindFrame(n, nBuffer);
            PVideoFrame frame = env->NewVideoFrame(vi);
            int nSize = frame->GetFrameBuffer()->GetDataSize() - frame->GetOffset();
            nSize = nSize > smbuf->GetFrameSize() ? smbuf->GetFrameSize() : nSize;
            memcpy(frame->GetWritePtr(), p, nSize);
            smbuf->UnlockAndRemoveFrameData(nBuffer);
            return frame;
        }
        
        bool __stdcall GetParity(int n)
        {
            return false;
        }
        
        void __stdcall GetAudio(void* buf, __int64 start, __int64 count, IScriptEnvironment* env)
        {
            return;
        }
        
        void __stdcall SetCacheHints(int cachehints,int frame_range)
        {
        }
        
        const VideoInfo& __stdcall GetVideoInfo()
        {
            return vi;
        }
        
        __stdcall ~SharedMemorySource()
        {
            delete region;
            delete sm;
        }
};


AVSValue __cdecl Create_SoraSMSource(AVSValue args, void* user_data, IScriptEnvironment* env)
{
    if(args[0].IsString())
        return AVSValue(new SharedMemorySource(env, args[0].AsString()));
    else
        env->ThrowError("SoraSMSource2:  Name is required.");
}

extern "C" __declspec(dllexport) const char* __stdcall AvisynthPluginInit2(IScriptEnvironment* env)
{
    env->AddFunction("SoraSMSource2", "[name]s", Create_SoraSMSource, 0);
    return 0;
}

int main(int argc, char* argv[])
{
    po::options_description paramDesc("Allowed options");
    paramDesc.add_options()
        ("buffer", po::value<int>()->default_value(12), "<integer> set buffer size (number of prefetched frame)")
        ("script", po::value<string>(), "<string> script file, required")
        ("name", po::value<string>(), "<string> name for shared memory, required")
        ("prefetch", po::value<string>(), "<string> lua script to control prefetch algorithm, optional")
    ;
    
    po::variables_map params;
    po::store(po::parse_command_line(argc, argv, paramDesc), params);
    po::notify(params);
    
    if(params.count("name") == 0 || params.count("script") == 0)
    {
        std::cout << paramDesc << std::endl;
        return 1;
    }

    IScriptEnvironment* (__stdcall *CSE)(int);
    CSE = (IScriptEnvironment* (__stdcall*) (int)) GetProcAddress(LoadLibrary("avisynth.dll"), "CreateScriptEnvironment");
    IScriptEnvironment* env = (*CSE)(AVISYNTH_INTERFACE_VERSION);
    
    //read the whole avs
    fstream fs(params["script"].as<string>().c_str(), std::ios::in);
    if(!fs)
    {
        puts("fail to open avs script file");
    }
    else
    {
        fs.seekg(0, std::ios::end);
        int flen = fs.tellg();
        fs.seekg(0, std::ios::beg);
        string buf(flen, ' ');
        fs.read(&buf[0], flen);
        fs.close();
        
        //run avs
        PClip p = env->Invoke("eval", buf.c_str()).AsClip();
        int nFrameSize;
        int nFrameCount;
        VideoInfo vi;
        { //get length
            PVideoFrame vf = p->GetFrame(0, env);
            nFrameSize = vf->GetFrameBuffer()->GetDataSize() - vf->GetOffset();
            vi = p->GetVideoInfo();
            nFrameCount = vi.num_frames;
        }
        
        //get next frame algorithm
        boost::scoped_ptr<IGetNextFrame> gnf;
        if(params.count("prefetch") == 0)
        {
            gnf.reset(new GetNextFrameDefault(nFrameCount));
        }
        else
        {
            try
            {
                gnf.reset(new GetNextFrameLua(params["prefetch"].as<string>().c_str(), nFrameCount));
            }
            catch(GetNextFrameLua::ScriptError)
            {
                cout << "incorrect lua script" << endl;
                return 1;
            }
        }

        int nBufferCount = params["buffer"].as<int>();

        //create shared memory
        int shmSize = SharedBuffer::RequiredSize(nFrameCount, nFrameSize, nBufferCount);
        boost::scoped_ptr<windows_shared_memory> shm;
        try
        {
            shm.reset(new windows_shared_memory(create_only, params["name"].as<string>().c_str(), read_write, shmSize));
        }
        catch(...)
        {
            cout << "Have you stop all process that works with sorasmsource2 with the same name?" << endl;
            return 1;
        }
        
        //get pointer
        mapped_region r(*shm, read_write);
        
        //create object
        SharedBuffer* smbuf = new(r.get_address()) SharedBuffer(vi, nFrameCount, nFrameSize, nBufferCount);
        
        cout << "Ready to serve frames." << endl;

        for(;;)
        {      
            int nFrameToRead;
            try
            {
                nFrameToRead = smbuf->StepToNextFrameToRead(gnf.get());
            }
            catch(GetNextFrameLua::ScriptError)
            {
                cout << "lua script runs into error, switch to default prefetch algorithm" << endl;
                gnf.reset(new GetNextFrameDefault(nFrameCount));
                nFrameToRead = smbuf->StepToNextFrameToRead(gnf.get());
            }
            
            PVideoFrame vf = p->GetFrame(nFrameToRead, env);
            
            int nBuffer;
            void* ptr = smbuf->FindEmptyFrameForWrite(nFrameToRead, nBuffer);
            
            smbuf->ReduceFrameLifeTime();
            
            int nNewFrameSize = vf->GetFrameBuffer()->GetDataSize() - vf->GetOffset();
            if(nNewFrameSize > nFrameSize) nNewFrameSize = nFrameSize;
            memcpy(ptr, vf->GetReadPtr(), nNewFrameSize);
            smbuf->UnlockFrameData(nBuffer);
        }
    }
}










