#define BOOST_ALL_NO_LIB
#include <windows.h>
#include "avisynth.h"
#include <deque>
#include <algorithm>

#include <iostream>

#include <boost/thread.hpp>
#include <boost/bind.hpp>
#include <boost/scoped_ptr.hpp>

#include "lua.hpp"

using boost::thread;
using boost::recursive_mutex;
using std::deque;
using boost::condition_variable_any;
using boost::unique_lock;

#include "getnextframe.h"

template<bool useCache, class T>
struct EnableUseCache;

template<class T>
struct EnableUseCache<true, T>
{
    typedef T Type;
};

template<class T>
struct EnableUseCache<false, T>
{
    typedef void* Type;
};

template<bool useCache>
class SoraThread : public GenericVideoFilter
{
    struct BufferedFrame
    {
        int nFrame; //֡
        int nLifeTimeLeft; //ʼֵڻ֡ÿһξͼһС0ʱ
        PVideoFrame frame; //֡

        
        const BufferedFrame& operator = (const BufferedFrame& bf)
        {
            nFrame = bf.nFrame;
            nLifeTimeLeft = bf.nLifeTimeLeft;
            frame = bf.frame;

            return *this;
        }
        
        BufferedFrame(const BufferedFrame& a)
        {
            *this = a;
        }
        
        BufferedFrame() { }
    };
    
    private:
        //֡
        int nFrameCount;
        
        //棬֡ݴ
        int nCacheCount;
        typename EnableUseCache<useCache, deque<BufferedFrame> >::Type frameCache;
        typename EnableUseCache<useCache, recursive_mutex >::Type frameCacheMutex;
        
        //壬û֡ݴԺƶ
        int nBufferCount;
        deque<BufferedFrame> frameBuffer;
        recursive_mutex frameBufferMutex;
        
        //ʱ֪ͨ
        condition_variable_any frameBufferChangedEvent;
        
        //߳
        thread processThread;
        
        //һ֡ʲô
        int nNextFrameToRead;
        recursive_mutex nextFrameToReadMutex;
        
        //һ֡ķ
        IGetNextFrame* nextFrameGetter;
        
        //֪ͨ߳
        recursive_mutex startEventMutex;
        condition_variable_any startEvent;
        
        IScriptEnvironment* firstEnv; //һͽenv
    public:
        SoraThread(IScriptEnvironment* env, PClip _child, int bc, int cc, const char* luascript)
            : GenericVideoFilter(_child)
            , nCacheCount(cc)
            , nBufferCount(bc)
        {
            nFrameCount = vi.num_frames;
            nNextFrameToRead = -1;
            if(luascript == 0)
                nextFrameGetter = new GetNextFrameDefault(nFrameCount);
            else
            {
                try
                {
                    nextFrameGetter = new GetNextFrameLua(luascript, nFrameCount);
                }
                catch(GetNextFrameLua::ScriptError)
                {
                    delete nextFrameGetter;
                    env->ThrowError("SoraThread:  Incorrect lua script.");
                }
            }
        }
        
        __stdcall ~SoraThread()
        {
            if( processThread.get_id() != boost::thread::id() )
            {
                processThread.interrupt();
                processThread.join();
            }
            delete nextFrameGetter;
        }
        
        PVideoFrame __stdcall GetFrame(int n, IScriptEnvironment* env)
        {
            PVideoFrame frame;
            if( processThread.get_id() == boost::thread::id() )
            {
                firstEnv = env;
                processThread = thread(boost::bind(&SoraThread::threadFunction, this));
                nNextFrameToRead = n;
                WaitForFrame(n, frame);
                
                return frame;
            }
            if( SearchCache(n, frame) ) //ڻҵҪ֡
            {
                ;
            }
            else if( SearchBuffer(n, frame) ) //ڻҵҪ֡
            {
                ;
            }
            else //ûҵ趨һ֡Ժȴ
            {
                {
                    unique_lock<recursive_mutex> lg(nextFrameToReadMutex);
                    nNextFrameToRead = n;
                }
                frameBufferChangedEvent.notify_all();
                WaitForFrame(n, frame);
            }
            
            return frame;
        }
        
        bool SearchCache(int nFrame, PVideoFrame& frame); //һ棬ҵԺµڵһ
        
        bool SearchBuffer(int nFrame, PVideoFrame& frame) //һ
        {
            unique_lock<recursive_mutex> lg(frameBufferMutex);
            
            deque<BufferedFrame>::iterator i = frameBuffer.begin();
            
            while(i != frameBuffer.end())
            {
                if(i->nFrame == nFrame)
                {
                    frame = i->frame;
                    CacheFrame(nFrame, frame);
                    i = frameBuffer.erase(i);
                    lg.unlock();
                    frameBufferChangedEvent.notify_all();
                    return true;
                }
                ++i;
            }
            return false;
        }
        
        void CacheFrame(int nFrame, PVideoFrame frame);
        
        void BufferFrame(int nFrame, PVideoFrame frame)
        {
            unique_lock<recursive_mutex> lg(frameBufferMutex);
            
            while(frameBuffer.size() >= nBufferCount) //˻ȴ
            {
                frameBufferChangedEvent.wait(lg);
            }
            
            ReduceBufferedFrameLifeTime();
            
            struct BufferedFrame bf;
            bf.frame = frame;
            bf.nFrame = nFrame;
            bf.nLifeTimeLeft = nBufferCount;
            frameBuffer.push_back(bf);
            
            lg.unlock();
            frameBufferChangedEvent.notify_all();
        }
        
        void ReduceBufferedFrameLifeTime()
        {
            unique_lock<recursive_mutex> lg(frameBufferMutex);
            
            deque<BufferedFrame>::iterator i = frameBuffer.begin();
            while(i != frameBuffer.end())
            {
                -- i->nLifeTimeLeft;
                if(i->nLifeTimeLeft <= 0)
                    i = frameBuffer.erase(i);
                else
                    ++i;
            }
            
            lg.unlock();
            frameBufferChangedEvent.notify_all();
        }
        
        void WaitForFrame(int nFrame, PVideoFrame& frame)
        {
            unique_lock<recursive_mutex> lg(frameBufferMutex);
            
            while(SearchBuffer(nFrame, frame) == false)
            {
                while(frameBuffer.size() >= nBufferCount)
                    ReduceBufferedFrameLifeTime();
                
                startEvent.notify_all();
                frameBufferChangedEvent.wait(lg);
            }
        }
        
        void threadFunction()
        {
            try
            {
                int nLastReadFrame = -1;
                int nFrameToRead = -1;
                for(;;)
                {
                    boost::this_thread::interruption_point();
                    {
                        unique_lock<recursive_mutex> lg(nextFrameToReadMutex);
                        nFrameToRead = nNextFrameToRead;
                        nNextFrameToRead = GetNextFrameToRead(nNextFrameToRead, firstEnv);
                    }
                    {
                        unique_lock<recursive_mutex> lg(startEventMutex);
                        while(nFrameToRead == -1)
                        {
                            startEvent.wait(lg);
                            {
                                unique_lock<recursive_mutex> lg2(nextFrameToReadMutex);
                                nFrameToRead = nNextFrameToRead;
                            }
                        }
                    }
                    
                    if(nLastReadFrame != nFrameToRead) //Ϊ˽ ߳2ڶ߳1󡪡߳2ꡪ߳1ߡ߳2õ󡪡ֻûСֶ
                    {
                        PVideoFrame vf = child->GetFrame(nFrameToRead, firstEnv);
                        
                        nLastReadFrame = nFrameToRead;
                        BufferFrame(nFrameToRead, vf);
                    }
                }
            }
            catch(boost::thread_interrupted)
            {
                ;
            }
        }
        
        int GetNextFrameToRead(int nCurrentFrame, IScriptEnvironment* env)
        {
            try
            {
                return nextFrameGetter->GetNextFrame(nCurrentFrame);
            }
            catch(GetNextFrameLua::ScriptError)
            {
                env->ThrowError("SoraThread:  lua script runs into error.");
                return -2;
            }
        }
};

template<>
void SoraThread<true>::CacheFrame(int nFrame, PVideoFrame frame)
{
    unique_lock<recursive_mutex> lg(frameCacheMutex);
    
    while(frameCache.size() >= nCacheCount)
        frameCache.pop_back();
    
    struct BufferedFrame bf;
    bf.frame = frame;
    bf.nFrame = nFrame;
    frameCache.push_front(bf);
}

template<>
void SoraThread<false>::CacheFrame(int nFrame, PVideoFrame frame)
{
}

template<>
bool SoraThread<true>::SearchCache(int nFrame, PVideoFrame& frame)
{
    unique_lock<recursive_mutex> lg(frameCacheMutex);
    
    deque<BufferedFrame>::iterator i = frameCache.begin();
    
    while(i != frameCache.end())
    {
        if(i->nFrame == nFrame)
        {
            frame = i->frame;
            std::swap(*i, *frameCache.begin());
            return true;
        }
        ++i;
    }
    return false;
}

template<>
bool SoraThread<false>::SearchCache(int nFrame, PVideoFrame& frame)
{
    return false;
}

AVSValue __cdecl Create_SoraThread(AVSValue args, void* user_data, IScriptEnvironment* env)
{
    if(args[0].IsClip())
    {
        int bufferCount = args[1].IsInt() ? args[1].AsInt() : 5;
        int cacheCount = args[2].IsInt() ? args[2].AsInt() : 0;
        const char* preFetch = args[3].IsString() ? args[3].AsString() : 0;
        if(cacheCount == 0)
            return AVSValue(new SoraThread<false>(env, args[0].AsClip(), bufferCount, cacheCount, preFetch));
        else
            return AVSValue(new SoraThread<true>(env, args[0].AsClip(), bufferCount, cacheCount, preFetch));
    }
    else
    {
        env->ThrowError("SoraThread:  No available clip!");
        return AVSValue(0);
    }
}

extern "C" __declspec(dllexport) const char* __stdcall AvisynthPluginInit2(IScriptEnvironment* env)
{
    env->AddFunction("SoraThread", "c[Buffer]i[Cache]i[Prefetch]s", Create_SoraThread, 0);
    return 0;
}
